document.addEventListener("DOMContentLoaded", function () {
  const registerForm = document.getElementById("registerForm");

  if (registerForm) {
    registerForm.addEventListener("submit", function (event) {
      event.preventDefault();

      const name = document.getElementById("name").value.trim();
      const emailOrPhone = document.getElementById("emailOrPhone").value.trim();
      const password = document.getElementById("password").value.trim();
      const confirmPassword = document
        .getElementById("confirmPassword")
        .value.trim();

      if (!name || !emailOrPhone || !password || !confirmPassword) {
        alert("Harap isi semua field!");
        return;
      }

      if (password !== confirmPassword) {
        alert("Kata sandi dan konfirmasi tidak cocok!");
        return;
      }

      const userData = {
        name: name,
        contact: emailOrPhone,
        password: password,
      };

      localStorage.setItem("registeredUser", JSON.stringify(userData));

      alert("Pendaftaran berhasil! Silakan login.");
      window.location.href = "login.html";
    });
  }
});
