let selectedNominal = null;
let selectedPayment = null;

// Nominal
document.querySelectorAll(".nominal-box").forEach((box) => {
  box.addEventListener("click", () => {
    document
      .querySelectorAll(".nominal-box")
      .forEach((b) => b.classList.remove("ring", "ring-yellow-400"));
    box.classList.add("ring", "ring-yellow-400");
    selectedNominal = box.innerText;
  });
});

// Pembayaran QRIS
const qrisButton = document.querySelector(".qris-button");
qrisButton?.addEventListener("click", () => {
  selectedPayment = "QRIS";
  highlightPayment(qrisButton);
});

// Pembayaran VA
const vaButtons = document.querySelectorAll(".va-button");
vaButtons.forEach((btn) => {
  btn.addEventListener("click", () => {
    selectedPayment = btn.textContent.trim();
    highlightPayment(btn);
  });
});

function highlightPayment(activeBtn) {
  [...vaButtons, qrisButton].forEach((btn) =>
    btn.classList.remove("ring", "ring-yellow-400")
  );
  activeBtn.classList.add("ring", "ring-yellow-400");
}

// Tombol bayar
document.querySelector(".submit-btn")?.addEventListener("click", () => {
  const userId = document.querySelectorAll(".input-userid")[0].value.trim();
  const zoneId = document.querySelectorAll(".input-userid")[1].value.trim();
  const whatsapp = document.querySelector(".input-konfirmasi").value.trim();

  if (!userId || !zoneId || !selectedNominal || !selectedPayment || !whatsapp) {
    alert("Harap lengkapi semua data sebelum melanjutkan!");
    return;
  }

  // Extract nominal
  const nominalText = selectedNominal.split("\n");
  const item = nominalText[0].trim();
  const hargaText = nominalText[1].trim();
  const harga = parseInt(hargaText.replace("Rp ", "").replace(/\./g, ""));

  const formData = new FormData();
  formData.append("users", `${userId}(${zoneId})`);
  formData.append("item", item);
  formData.append("jumlah", 1);
  formData.append("harga_satuan", harga);
  formData.append("metode_pembayaran", selectedPayment);
  formData.append("whatsapp", whatsapp);

  console.log({
    users: `${userId}(${zoneId})`,
    item,
    harga,
    selectedPayment,
    whatsapp,
  });

  fetch("backend/proses-transaksi.php", {
    method: "POST",
    body: formData,
  })
    .then((res) => res.json())
    .then((data) => {
      if (data.success) {
        window.location.href = data.redirect_url;
      } else {
        alert("Error: " + data.message);
      }
    })
    .catch((err) => {
      console.error("Fetch Error:", err);
      alert("Terjadi kesalahan. Coba lagi.");
    });
});
