<?php
session_start();
include 'config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

// Helper function untuk format angka
function formatNumber($value) {
    if (is_numeric($value)) {
        return number_format($value);
    }
    return htmlspecialchars($value);
}

// Helper function untuk format mata uang
function formatCurrency($value) {
    if (is_numeric($value)) {
        return 'Rp ' . number_format($value);
    }
    return 'Rp ' . htmlspecialchars($value);
}

// Handle status update
if (isset($_POST['update_status'])) {
    $id = $_POST['id'];
    $new_status = $_POST['status'];
    
    $stmt = $pdo->prepare("UPDATE transaksi SET status = ? WHERE id = ?");
    if ($stmt->execute([$new_status, $id])) {
        $message = "Status transaksi berhasil diupdate!";
    } else {
        $error = "Gagal mengupdate status!";
    }
}

// Handle delete transaction
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM transaksi WHERE id = ?");
    if ($stmt->execute([$id])) {
        $message = "Transaksi berhasil dihapus!";
    } else {
        $error = "Gagal menghapus transaksi!";
    }
}

// Ambil data untuk ditampilkan
$stmt = $pdo->query("SELECT * FROM transaksi ORDER BY id DESC");
$transaksi = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Transaksi - KMG Store</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #2563eb;
            --primary-dark: #1d4ed8;
            --success-color: #16a34a;
            --success-dark: #15803d;
            --warning-color: #f59e0b;
            --warning-dark: #d97706;
            --danger-color: #dc2626;
            --danger-dark: #b91c1c;
            --bg-color: #f8fafc;
            --border-color: #e5e7eb;
            --text-color: #374151;
            --text-muted: #6b7280;
            --sidebar-width: 250px;
            --border-radius: 12px;
            --box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--bg-color);
            color: var(--text-color);
            line-height: 1.6;
        }

        /* Sidebar Styles - SAMA PERSIS DENGAN PRODUCTLIST.PHP */
        .sidebar {
            width: var(--sidebar-width);
            position: fixed;
            height: 100vh;
            background-color: #ffffff;
            border-right: 1px solid var(--border-color);
            padding: 2rem 1.5rem;
            box-shadow: var(--box-shadow);
            z-index: 1000;
        }

        .sidebar .logo {
            margin-bottom: 2rem;
            text-align: center;
            border-bottom: 1px solid var(--border-color);
            padding-bottom: 1rem;
        }

        .sidebar .logo h4 {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .sidebar .logo small {
            color: var(--text-muted);
            font-size: 0.875rem;
        }

        .sidebar .nav-link {
            color: var(--text-color);
            padding: 0.875rem 1rem;
            margin-bottom: 0.5rem;
            border-radius: 8px;
            text-decoration: none;
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .sidebar .nav-link:hover {
            background-color: #f0f9ff;
            color: var(--primary-color);
            transform: translateX(4px);
        }

        .sidebar .nav-link.active {
            background-color: var(--primary-color);
            color: white;
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);
        }

        .sidebar .nav-link i {
            margin-right: 0.75rem;
            width: 18px;
            text-align: center;
        }

        .sidebar hr {
            border: 0;
            border-top: 1px solid var(--border-color);
            margin: 1.5rem 0;
        }

        .sidebar .nav-link.text-danger:hover {
            background-color: #fef2f2;
            color: var(--danger-color);
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            padding: 2rem;
            min-height: 100vh;
        }

        .card-custom {
            border-radius: 16px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.05);
        }
        .table th {
            background-color: #f1f5f9;
            font-weight: 600;
        }
        .product-image {
            width: 60px;
            height: 60px;
            object-fit: cover;
            border-radius: 8px;
        }
        .price-badge {
            background-color: #10b981;
            color: white;
            font-weight: bold;
            padding: 4px 8px;
            border-radius: 6px;
            font-size: 0.85rem;
        }
        .category-badge {
            background-color: #3b82f6;
            color: white;
            font-size: 0.75rem;
            padding: 2px 8px;
            border-radius: 12px;
        }
        .brand-badge {
            background-color: #8b5cf6;
            color: white;
            font-size: 0.75rem;
            padding: 2px 8px;
            border-radius: 12px;
        }
        
        /* Status Badge Styling - PERBAIKAN */
        .status-badge {
            font-size: 0.75rem;
            padding: 4px 8px;
            border-radius: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }
        .status-pending {
            background-color: #f59e0b !important;
            color: white !important;
        }
        .status-success {
            background-color: #10b981 !important;
            color: white !important;
        }
        .status-failed {
            background-color: #ef4444 !important;
            color: white !important;
        }
        
        .form-control:focus {
            border-color: #2563eb;
            box-shadow: 0 0 0 0.2rem rgba(37, 99, 235, 0.25);
        }
        .btn-primary {
            background-color: #2563eb;
            border-color: #2563eb;
        }
        .btn-primary:hover {
            background-color: #1d4ed8;
            border-color: #1d4ed8;
        }
        .stats-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: white;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.2s ease;
        }
        .stat-card:hover {
            transform: translateY(-2px);
        }
        .stat-number {
            font-size: 2rem;
            font-weight: bold;
            color: #1f2937;
            margin: 10px 0;
        }
        .search-container {
            background: white;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .card {
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border: none;
        }
        .card-header {
            background-color: #f8fafc;
            border-bottom: 1px solid #e5e7eb;
            border-radius: 12px 12px 0 0 !important;
        }
        .alert {
            border-radius: 12px;
            border: none;
        }
        .btn {
            border-radius: 8px;
            transition: all 0.2s ease;
        }
        .btn:hover {
            transform: translateY(-1px);
        }
        .empty-state {
            text-align: center;
            padding: 40px 20px;
        }
        .empty-state i {
            font-size: 4rem;
            color: #9ca3af;
            margin-bottom: 20px;
        }
        .empty-state h5 {
            color: #6b7280;
            margin-bottom: 10px;
        }
        .empty-state p {
            color: #9ca3af;
        }
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }
            .main-content {
                margin-left: 0;
                padding: 20px;
            }
            .stats-cards {
                grid-template-columns: repeat(2, 1fr);
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar - SAMA PERSIS DENGAN PRODUCTLIST.PHP -->
    <div class="sidebar">
        <div class="logo">
            <h4><i class="fas fa-store"></i> KMG Store</h4>
            <small>Admin Panel</small>
        </div>

        <nav class="nav flex-column">
            <a class="nav-link" href="admin-dashboard.php">
                <i class="fas fa-tachometer-alt"></i> Dashboard
            </a>
            <a class="nav-link active" href="transaksi.php">
                <i class="fas fa-shopping-cart"></i> Transaksi
            </a>
            <a class="nav-link" href="pengguna.php">
                <i class="fas fa-users"></i> Pengguna
            </a>
            <a class="nav-link" href="productlist.php">
                <i class="fas fa-boxes"></i> Product List
            </a>
            <a class="nav-link" href="add_product.php">
                <i class="fas fa-plus-circle"></i> Tambah Produk
            </a>
            
            <hr>
            
            <a class="nav-link text-danger" href="logout.php">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <h1 class="mb-4"><i class="fas fa-shopping-cart text-primary"></i> Data Transaksi</h1>
                    
                    <?php if (isset($message)): ?>
                        <div class="alert alert-success alert-dismissible fade show">
                            <i class="fas fa-check-circle"></i> <?php echo $message; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <?php if (isset($error)): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <!-- Statistik Transaksi -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card card-custom bg-primary text-white">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="card-title">Total Transaksi</h6>
                                            <h3><?php echo count($transaksi); ?></h3>
                                        </div>
                                        <div class="align-self-center">
                                            <i class="fas fa-shopping-cart fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card card-custom bg-warning text-dark">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="card-title">Pending</h6>
                                            <h3><?php echo count(array_filter($transaksi, function($t) { return $t['status'] == 'pending'; })); ?></h3>
                                        </div>
                                        <div class="align-self-center">
                                            <i class="fas fa-clock fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card card-custom bg-success text-white">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="card-title">Berhasil</h6>
                                            <h3><?php echo count(array_filter($transaksi, function($t) { return $t['status'] == 'success'; })); ?></h3>
                                        </div>
                                        <div class="align-self-center">
                                            <i class="fas fa-check fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card card-custom bg-danger text-white">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="card-title">Gagal</h6>
                                            <h3><?php echo count(array_filter($transaksi, function($t) { return $t['status'] == 'failed'; })); ?></h3>
                                        </div>
                                        <div class="align-self-center">
                                            <i class="fas fa-times fa-2x"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabel Transaksi -->
                    <div class="card card-custom">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0"><i class="fas fa-list"></i> Daftar Transaksi</h5>
                            <button class="btn btn-primary" onclick="location.reload()">
                                <i class="fas fa-sync-alt"></i> Refresh
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Kode Transaksi</th>
                                            <th>User ID</th>
                                            <th>Tanggal</th>
                                            <th>Nama Game</th>
                                            <th>User ID Game</th>
                                            <th>Item/Jenis</th>
                                            <th>Nominal</th>
                                            <th>Total Bayar</th>
                                            <th>Metode</th>
                                            <th>WhatsApp</th>
                                            <th>Status</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (count($transaksi) > 0): ?>
                                            <?php foreach ($transaksi as $row): ?>
                                                <tr>
                                                    <td><span class="badge bg-primary"><?= $row['id'] ?></span></td>
                                                    <td><code><?= htmlspecialchars($row['kode_transaksi']) ?></code></td>
                                                    <td><span class="badge bg-info"><?= htmlspecialchars($row['user_id']) ?></span></td>
                                                    <td><?= date('d/m/Y H:i', strtotime($row['tanggal'])) ?></td>
                                                    <td><strong><?= htmlspecialchars($row['nama_game']) ?></strong></td>
                                                    <td><?= htmlspecialchars($row['userid_game']) ?></td>
                                                    <td><?= htmlspecialchars($row['item_jenis']) ?></td>
                                                    <td><?= formatNumber($row['nominal']) ?></td>
                                                    <td><strong><?= formatCurrency($row['total_bayar']) ?></strong></td>
                                                    <td>
                                                        <span class="badge bg-secondary"><?= htmlspecialchars($row['metode_pembayaran']) ?></span>
                                                    </td>
                                                    <td><?= htmlspecialchars($row['whatsapp']) ?></td>
                                                    <td>
                                                        <span class="badge status-badge status-<?= $row['status'] ?>">
                                                            <?= ucfirst($row['status']) ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <button type="button" class="btn btn-sm btn-outline-primary" 
                                                                    onclick="updateStatus(<?= $row['id'] ?>, '<?= $row['status'] ?>')"
                                                                    title="Update Status">
                                                                <i class="fas fa-edit"></i>
                                                            </button>
                                                            <button type="button" class="btn btn-sm btn-outline-danger" 
                                                                    onclick="deleteTransaction(<?= $row['id'] ?>)"
                                                                    title="Hapus Transaksi">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="13" class="text-center">
                                                    <div class="py-4">
                                                        <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                                                        <p class="text-muted">Belum ada data transaksi</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Update Status -->
    <div class="modal fade" id="statusModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Update Status Transaksi</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <input type="hidden" name="update_status" value="1">
                        <input type="hidden" name="id" id="statusId">
                        <div class="mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-select" name="status" id="statusSelect" required>
                                <option value="pending">Pending</option>
                                <option value="success">Success</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">Update Status</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script>
        function updateStatus(id, currentStatus) {
            document.getElementById('statusId').value = id;
            document.getElementById('statusSelect').value = currentStatus;
            new bootstrap.Modal(document.getElementById('statusModal')).show();
        }

        function deleteTransaction(id) {
            if (confirm('Apakah Anda yakin ingin menghapus transaksi ini?')) {
                window.location.href = `?delete=${id}`;
            }
        }

        // Auto hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    </script>
</body>
</html>