<?php
session_start();
include_once("config.php");
include_once("functions.php");

cek_login_user();

if (!isset($_SESSION['user_id'])) {
    header("Location: masuk.html");
    exit();
}

// Cek apakah data transaksi tersimpan di session
if (!isset($_SESSION['transaksi'])) {
    header("Location: index.php");
    exit();
}

$transaksi = $_SESSION['transaksi'];
$user_id = $_SESSION['user_id'];

$kode       = $transaksi['kode'];
$tanggal    = $transaksi['tanggal'];
$userid     = $transaksi['userid'];
$zoneid     = $transaksi['zoneid'];
$nominal    = $transaksi['nominal'];
$harga      = $transaksi['harga'];
$metode     = $transaksi['metode'];
$status     = 'pending'; // atau 'paid' jika langsung dibayar

// Simpan ke database
$query = "INSERT INTO transaksi (kode_transaksi, user_id, tanggal, userid, zoneid, nominal, harga, metode, status)
          VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = mysqli_prepare($conn, $query);

if ($stmt) {
    mysqli_stmt_bind_param($stmt, "sissssiss", $kode, $user_id, $tanggal, $userid, $zoneid, $nominal, $harga, $metode, $status);
    if (mysqli_stmt_execute($stmt)) {
        header("Location: struk-pembayaran.php");
        exit();
    } else {
        echo "Gagal menyimpan transaksi.";
    }
    mysqli_stmt_close($stmt);
} else {
    echo "Query gagal disiapkan.";
}

mysqli_close($conn);



$transaksi = $_SESSION['transaksi'];



?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Struk Pembayaran - KMGSTORE</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #1e1e1e;
      color: #fff;
    }
    .navbar {
      position: relative;
      background: #1e2635;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 10px 20px;
      z-index: 5;
      backdrop-filter: blur(10px);
    }
    .container {
      max-width: 800px;
      margin: auto;
      padding: 20px;
    }
    .receipt-box {
      background: rgba(42, 42, 42, 0.8);
      backdrop-filter: blur(10px);
      padding: 20px;
      border-radius: 10px;
      margin-top: 20px;
    }
    .receipt-header {
      text-align: center;
      border-bottom: 1px dashed #aaa;
      padding-bottom: 15px;
      margin-bottom: 15px;
    }
    .receipt-details {
      background: rgba(0, 0, 0, 0.2);
      padding: 15px;
      border-radius: 5px;
      margin: 15px 0;
    }
    .detail-row {
      display: flex;
      justify-content: space-between;
      padding: 8px 0;
      border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }
    .status-paid {
      background: #28a745;
      color: white;
      padding: 5px 15px;
      border-radius: 20px;
      font-weight: bold;
      display: inline-block;
      margin-top: 10px;
    }
    .submit-btn {
      background: goldenrod;
      border: none;
      padding: 15px;
      width: 100%;
      color: rgb(85, 32, 32);
      font-weight: bold;
      font-size: 16px;
      border-radius: 5px;
      cursor: pointer;
      margin-top: 20px;
    }
    .footer-bottom {
      background-color: #1e2635;
      color: white;
      padding: 20px;
      text-align: center;
      font-size: 13px;
      margin-top: 40px;
    }
    .note {
      background: rgba(255, 255, 255, 0.1);
      padding: 10px;
      border-radius: 5px;
      font-size: 14px;
      margin-top: 20px;
    }
  </style>
</head>
<body>

  <nav class="navbar">
    <div class="text-lg font-bold tracking-wide">
      KMG<span class="text-white">STORE</span>
    </div>
    <div class="flex items-center space-x-2">
      <?php if (isset($_SESSION['nama'])): ?>
        <span class="text-white font-semibold">Halo, <?= htmlspecialchars($_SESSION['nama']) ?></span>
        <a href="index.php" class="bg-red-500 text-black px-3 py-1 rounded">Home</a>
      <?php else: ?>
        <a href="masuk.html" class="bg-yellow-500 text-black px-3 py-1 rounded">Masuk</a>
        <a href="daftar.html" class="bg-gray-700 px-3 py-1 rounded border border-yellow-500">Daftar</a>
      <?php endif; ?>
    </div>
  </nav>

  <div class="container">
    <div class="receipt-box">
      <div class="receipt-header">
        <h1 class="text-2xl font-bold">STRUK PEMBAYARAN</h1>
        <p>KMGSTORE</p>
        <div class="status-paid">LUNAS</div>
      </div>
      
      <div class="receipt-details">
        <div class="detail-row">
          <div>ID Transaksi</div>
          <div><?= $transaksi['kode'] ?></div>
        </div>
        <div class="detail-row">
          <div>Tanggal</div>
          <div><?= date('d-m-Y H:i', strtotime($transaksi['tanggal'])) ?></div>
        </div>
        <div class="detail-row">
          <div>Game</div>
          <div>Mobile Legends</div>
        </div>
        <div class="detail-row">
          <div>User ID</div>
          <div><?= $transaksi['userid'] ?> (<?= $transaksi['zoneid'] ?>)</div>
        </div>
        <div class="detail-row">
          <div>Item</div>
          <div><?= $transaksi['nominal'] ?></div>
        </div>
        <div class="detail-row">
          <div>Metode Pembayaran</div>
          <div><?= $transaksi['metode'] ?></div>
        </div>
        <div class="detail-row">
          <div><strong>Total Pembayaran</strong></div>
          <div><strong>Rp <?= number_format(intval($transaksi['harga']), 0, ',', '.') ?></strong></div>
        </div>
      </div>

      <div class="note">
        <p><strong>Catatan:</strong></p>
        <p>- Pembayaran berhasil diverifikasi</p>
        <p>- Mohon simpan struk ini sebagai bukti pembayaran</p>
        <p>- Diamond akan segera ditambahkan ke akun Mobile Legends Anda</p>
        <p>- Proses biasanya membutuhkan waktu 5-30 menit</p>
      </div>

      <div class="mt-4 text-center">
        <p>Terima kasih telah berbelanja di KMGSTORE!</p>
      </div>

      <form action="proses-pembayaran.php" method="POST">
        <input type="hidden" name="kode_transaksi" value="<?= $transaksi['kode'] ?>">
        <button type="submit" class="submit-btn">Lihat Status Pesanan</button>
      </form>
    </div>
  </div>

  <div class="footer-bottom">© 2024 KMGSTORE. All Rights Reserved.</div>

  <script>
    // Setelah 5 detik, simpan bukti struk di localStorage (opsional)
    setTimeout(function() {
      localStorage.setItem('lastTransaction', '<?= $transaksi['kode'] ?>');
    }, 5000);
  </script>

</body>
</html>