<?php
// Konfigurasi database
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'kmgstore';

// Membuat koneksi ke database
$conn = new mysqli($host, $username, $password, $database);

// Cek koneksi
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Set charset untuk menghindari masalah encoding
$conn->set_charset("utf8");

// Proses penghapusan produk
$message = '';
$messageType = '';

if (isset($_GET['delete_id'])) {
    $delete_id = (int)$_GET['delete_id'];
    
    // Query untuk menghapus produk
    $delete_sql = "DELETE FROM produk WHERE product_id = ?";
    $stmt = $conn->prepare($delete_sql);
    $stmt->bind_param("i", $delete_id);
    
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            $message = "Produk berhasil dihapus!";
            $messageType = "success";
        } else {
            $message = "Produk tidak ditemukan!";
            $messageType = "error";
        }
    } else {
        $message = "Error: " . $stmt->error;
        $messageType = "error";
    }
    
    $stmt->close();
    
    // Redirect untuk menghindari refresh form resubmission
    header("Location: productlist.php?msg=" . urlencode($message) . "&type=" . $messageType);
    exit();
}

// Tampilkan pesan jika ada
if (isset($_GET['msg']) && isset($_GET['type'])) {
    $message = $_GET['msg'];
    $messageType = $_GET['type'];
}

// Fungsi untuk memproses pencarian
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';

// Query untuk mengambil data produk
if (!empty($search)) {
    $sql = "SELECT * FROM produk 
            WHERE product_nama_game LIKE '%$search%' 
            OR product_item_jenis LIKE '%$search%'
            OR product_nominal LIKE '%$search%'
            ORDER BY product_id ASC";
} else {
    $sql = "SELECT * FROM produk ORDER BY product_id ASC";
}

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Produk - KMGSTORE</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        
        :root {
            --primary-color: #2563eb;
            --primary-dark: #1d4ed8;
            --success-color: #16a34a;
            --success-dark: #15803d;
            --warning-color: #f59e0b;
            --warning-dark: #d97706;
            --danger-color: #dc2626;
            --danger-dark: #b91c1c;
            --bg-color: #f8fafc;
            --border-color: #e5e7eb;
            --text-color: #374151;
            --text-muted: #6b7280;
            --sidebar-width: 250px;
            --border-radius: 12px;
            --box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--bg-color);
            color: var(--text-color);
            line-height: 1.6;
        }

        /* Alert Styles */
        .alert {
            padding: 1rem 1.5rem;
            border-radius: var(--border-radius);
            margin-bottom: 2rem;
            border: none;
            box-shadow: var(--box-shadow);
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .alert-success {
            background-color: #f0f9ff;
            color: var(--success-color);
            border-left: 4px solid var(--success-color);
        }

        .alert-error {
            background-color: #fef2f2;
            color: var(--danger-color);
            border-left: 4px solid var(--danger-color);
        }

        .alert-close {
            background: none;
            border: none;
            font-size: 1.25rem;
            cursor: pointer;
            color: inherit;
            margin-left: auto;
            opacity: 0.7;
        }

        .alert-close:hover {
            opacity: 1;
        }

        /* Sidebar Styles */
        .sidebar {
            width: var(--sidebar-width);
            position: fixed;
            height: 100vh;
            background-color: #ffffff;
            border-right: 1px solid var(--border-color);
            padding: 2rem 1.5rem;
            box-shadow: var(--box-shadow);
            z-index: 1000;
        }

        .sidebar .logo {
            margin-bottom: 2rem;
            text-align: center;
            border-bottom: 1px solid var(--border-color);
            padding-bottom: 1rem;
        }

        .sidebar .logo h4 {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .sidebar .logo small {
            color: var(--text-muted);
            font-size: 0.875rem;
        }

        .sidebar .nav-link {
            color: var(--text-color);
            padding: 0.875rem 1rem;
            margin-bottom: 0.5rem;
            border-radius: 8px;
            text-decoration: none;
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .sidebar .nav-link:hover {
            background-color: #f0f9ff;
            color: var(--primary-color);
            transform: translateX(4px);
        }

        .sidebar .nav-link.active {
            background-color: var(--primary-color);
            color: white;
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);
        }

        .sidebar .nav-link i {
            margin-right: 0.75rem;
            width: 18px;
            text-align: center;
        }

        .sidebar hr {
            border: 0;
            border-top: 1px solid var(--border-color);
            margin: 1.5rem 0;
        }

        .sidebar .nav-link.text-danger:hover {
            background-color: #fef2f2;
            color: var(--danger-color);
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            padding: 2rem;
            min-height: 100vh;
        }

        .content-header {
            background: white;
            padding: 2rem;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 2rem;
        }

        .content-header h1 {
            color: var(--text-color);
            margin: 0;
            font-size: 2rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        /* Search and Add Container */
        .search-add-container {
            background: white;
            padding: 1.5rem;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .search-form {
            display: flex;
            gap: 0.75rem;
            align-items: center;
            flex-wrap: wrap;
        }

        .search-input {
            padding: 0.75rem 1rem;
            border: 2px solid var(--border-color);
            border-radius: 8px;
            width: 320px;
            min-width: 250px;
            font-size: 0.875rem;
            transition: border-color 0.3s ease;
        }

        .search-input:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }

        /* Button Styles */
        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            font-size: 0.875rem;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            text-align: center;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        .btn-primary {
            background-color: var(--primary-color);
            color: white;
        }

        .btn-primary:hover {
            background-color: var(--primary-dark);
        }

        .btn-success {
            background-color: var(--success-color);
            color: white;
        }

        .btn-success:hover {
            background-color: var(--success-dark);
        }

        .btn-warning {
            background-color: var(--warning-color);
            color: white;
        }

        .btn-warning:hover {
            background-color: var(--warning-dark);
        }

        .btn-danger {
            background-color: var(--danger-color);
            color: white;
        }

        .btn-danger:hover {
            background-color: var(--danger-dark);
        }

        .btn-sm {
            padding: 0.5rem 1rem;
            font-size: 0.75rem;
        }

        /* Table Styles */
        .table-container {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
        }

        .table th {
            background-color: var(--bg-color);
            color: var(--text-color);
            font-weight: 700;
            text-transform: uppercase;
            font-size: 0.75rem;
            letter-spacing: 0.5px;
            padding: 1.25rem;
            border-bottom: 2px solid var(--border-color);
            text-align: left;
        }

        .table td {
            padding: 1.25rem;
            border-bottom: 1px solid #f3f4f6;
            vertical-align: middle;
        }

        .table tbody tr {
            transition: background-color 0.2s ease;
        }

        .table tbody tr:hover {
            background-color: #f9fafb;
        }

        .table tbody tr:last-child td {
            border-bottom: none;
        }

        /* Badge Styles */
        .badge {
            padding: 0.5rem 0.875rem;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 700;
            display: inline-block;
        }

        .badge-primary {
            background-color: #dbeafe;
            color: #1e40af;
        }

        /* Currency Styling */
        .currency {
            text-align: right;
            font-weight: 700;
            color: var(--success-color);
            font-size: 0.875rem;
            font-family: 'Courier New', monospace;
            background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
            padding: 0.5rem 0.75rem;
            border-radius: 8px;
            border-left: 4px solid var(--success-color);
            min-width: 120px;
            display: inline-block;
            box-shadow: 0 2px 4px rgba(22, 163, 74, 0.1);
            transition: all 0.3s ease;
        }

        .currency:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(22, 163, 74, 0.15);
        }

        .currency-symbol {
            font-size: 0.75rem;
            opacity: 0.8;
            margin-right: 0.25rem;
        }

        /* Product Actions */
        .product-actions {
            display: flex;
            gap: 0.5rem;
            justify-content: flex-end;
        }

        /* No Data State */
        .no-data {
            text-align: center;
            color: var(--text-muted);
            padding: 4rem 2rem;
        }

        .no-data i {
            font-size: 3rem;
            color: #d1d5db;
            margin-bottom: 1.5rem;
        }

        .no-data p {
            font-size: 1.125rem;
            margin: 0;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }

            .main-content {
                margin-left: 0;
            }

            .search-add-container {
                flex-direction: column;
                align-items: stretch;
            }

            .search-form {
                width: 100%;
            }

            .search-input {
                width: 100%;
            }

            .product-actions {
                flex-direction: column;
                gap: 0.25rem;
            }

            .table-container {
                overflow-x: auto;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="logo">
            <h4><i class="fas fa-store"></i> KMG Store</h4>
            <small>Admin Panel</small>
        </div>

        <nav class="nav flex-column">
            <a class="nav-link" href="admin-dashboard.php">
                <i class="fas fa-tachometer-alt"></i> Dashboard
            </a>
            <a class="nav-link" href="transaksi.php">
                <i class="fas fa-shopping-cart"></i> Transaksi
            </a>
            <a class="nav-link" href="pengguna.php">
                <i class="fas fa-users"></i> Pengguna
            </a>
            <a class="nav-link active" href="productlist.php">
                <i class="fas fa-boxes"></i> Product List
            </a>
            <a class="nav-link" href="add_product.php">
                <i class="fas fa-plus-circle"></i> Tambah Produk
            </a>
            
            <hr>
            
            <a class="nav-link text-danger" href="logout.php">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Content Header -->
        <div class="content-header">
            <h1>
                <i class="fas fa-boxes" style="color: var(--primary-color);"></i>
                Daftar Produk KMGSTORE
            </h1>
        </div>

        <!-- Alert Messages -->
        <?php if (!empty($message)): ?>
            <div class="alert alert-<?php echo $messageType; ?>" id="alert-message">
                <i class="fas fa-<?php echo $messageType == 'success' ? 'check-circle' : 'exclamation-circle'; ?>"></i>
                <?php echo htmlspecialchars($message); ?>
                <button type="button" class="alert-close" onclick="closeAlert()">&times;</button>
            </div>
        <?php endif; ?>

        <!-- Search and Add Container -->
        <div class="search-add-container">
            <form method="GET" action="" class="search-form">
                <input type="text" 
                       name="search" 
                       class="search-input" 
                       placeholder="Cari produk berdasarkan nama game, jenis item, atau nominal..." 
                       value="<?php echo htmlspecialchars($search); ?>">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-search"></i> Cari
                </button>
                <?php if (!empty($search)): ?>
                    <a href="productlist.php" class="btn btn-warning">
                        <i class="fas fa-times"></i> Reset
                    </a>
                <?php endif; ?>
            </form>
            
            <a href="add_product.php" class="btn btn-success">
                <i class="fas fa-plus"></i> Tambah Produk
            </a>
        </div>

        <!-- Table Container -->
        <div class="table-container">
            <?php if ($result && $result->num_rows > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nama Game</th>
                            <th>Jenis Item</th>
                            <th>Nominal</th>
                            <th style="text-align: right; min-width: 140px;">Total Bayar</th>
                            <th style="text-align: center; min-width: 120px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td>
                                <span class="badge badge-primary">
                                    <?php echo htmlspecialchars($row['product_id']); ?>
                                </span>
                            </td>
                            <td style="font-weight: 600;">
                                <?php echo htmlspecialchars($row['product_nama_game']); ?>
                            </td>
                            <td>
                                <?php echo htmlspecialchars($row['product_item_jenis']); ?>
                            </td>
                            <td style="font-weight: 600;">
                                <?php echo htmlspecialchars($row['product_nominal']); ?>
                            </td>
                            <td style="text-align: right;">
                                <div class="currency">
                                    <span class="currency-symbol">Rp</span><?php echo number_format($row['product_total_bayar'], 0, ',', '.'); ?>
                                </div>
                            </td>
                            <td class="product-actions">
                                <a href="edit_product.php?id=<?php echo $row['product_id']; ?>" 
                                   class="btn btn-warning btn-sm"
                                   title="Edit produk">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                <a href="javascript:void(0);" 
                                   class="btn btn-danger btn-sm" 
                                   title="Hapus produk"
                                   onclick="confirmDelete(<?php echo $row['product_id']; ?>, '<?php echo htmlspecialchars($row['product_nama_game']); ?>')">
                                    <i class="fas fa-trash-alt"></i> Hapus
                                </a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="no-data">
                    <i class="fas fa-search"></i>
                    <p>
                        <?php echo !empty($search) ? "Tidak ada produk yang ditemukan dengan kata kunci: <strong>$search</strong>" : "Tidak ada data produk yang ditemukan."; ?>
                    </p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script>
        // Confirmation dialog untuk delete
        function confirmDelete(productId, productName) {
            if (confirm(`Apakah Anda yakin ingin menghapus produk "${productName}"?`)) {
                // Redirect ke halaman yang sama dengan parameter delete_id
                window.location.href = `productlist.php?delete_id=${productId}`;
            }
        }

        // Close alert function
        function closeAlert() {
            document.getElementById('alert-message').style.display = 'none';
        }

        // Auto-hide alert after 5 seconds
        setTimeout(function() {
            const alertElement = document.getElementById('alert-message');
            if (alertElement) {
                alertElement.style.opacity = '0';
                setTimeout(() => {
                    alertElement.style.display = 'none';
                }, 300);
            }
        }, 5000);

        // Auto-focus pada search input
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.querySelector('.search-input');
            if (searchInput && !searchInput.value) {
                searchInput.focus();
            }
        });

        // Keyboard shortcut untuk search (Ctrl+K)
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && e.key === 'k') {
                e.preventDefault();
                document.querySelector('.search-input').focus();
            }
        });
    </script>
</body>
</html>

<?php
// Tutup koneksi database
if (isset($conn)) {
    $conn->close();
}
?>