<?php
session_start();
include 'config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

// Handle form actions
if ($_POST) {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'add':
            $nama = $_POST['nama'];
            $email = $_POST['email'];
            $nohp = $_POST['nohp'];
            $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            
            $stmt = $pdo->prepare("INSERT INTO users (nama, email, nohp, password) VALUES (?, ?, ?, ?)");
            $stmt->execute([$nama, $email, $nohp, $password]);
            $message = "Pengguna berhasil ditambahkan!";
            break;
            
        case 'edit':
            $id = $_POST['id'];
            $nama = $_POST['nama'];
            $email = $_POST['email'];
            $nohp = $_POST['nohp'];
            
            if (!empty($_POST['password'])) {
                $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("UPDATE users SET nama = ?, email = ?, nohp = ?, password = ? WHERE id = ?");
                $stmt->execute([$nama, $email, $nohp, $password, $id]);
            } else {
                $stmt = $pdo->prepare("UPDATE users SET nama = ?, email = ?, nohp = ? WHERE id = ?");
                $stmt->execute([$nama, $email, $nohp, $id]);
            }
            $message = "Pengguna berhasil diupdate!";
            break;
            
        case 'delete':
            $id = $_POST['id'];
            $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
            $stmt->execute([$id]);
            $message = "Pengguna berhasil dihapus!";
            break;
    }
}

// Get all users
$stmt = $pdo->query("SELECT * FROM users ORDER BY id DESC");
$users = $stmt->fetchAll();

// Get user for editing
$edit_user = null;
if (isset($_GET['edit'])) {
    $edit_id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$edit_id]);
    $edit_user = $stmt->fetch();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Kelola Pengguna - Admin KMG Store</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #2563eb;
            --primary-dark: #1d4ed8;
            --success-color: #16a34a;
            --success-dark: #15803d;
            --warning-color: #f59e0b;
            --warning-dark: #d97706;
            --danger-color: #dc2626;
            --danger-dark: #b91c1c;
            --bg-color: #f8fafc;
            --border-color: #e5e7eb;
            --text-color: #374151;
            --text-muted: #6b7280;
            --sidebar-width: 250px;
            --border-radius: 12px;
            --box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--bg-color);
            color: var(--text-color);
            line-height: 1.6;
        }

        /* Sidebar Styles */
        .sidebar {
            width: var(--sidebar-width);
            position: fixed;
            height: 100vh;
            background-color: #ffffff;
            border-right: 1px solid var(--border-color);
            padding: 2rem 1.5rem;
            box-shadow: var(--box-shadow);
            z-index: 1000;
        }

        .sidebar .logo {
            margin-bottom: 2rem;
            text-align: center;
            border-bottom: 1px solid var(--border-color);
            padding-bottom: 1rem;
        }

        .sidebar .logo h4 {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .sidebar .logo small {
            color: var(--text-muted);
            font-size: 0.875rem;
        }

        .sidebar .nav-link {
            color: var(--text-color);
            padding: 0.875rem 1rem;
            margin-bottom: 0.5rem;
            border-radius: 8px;
            text-decoration: none;
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .sidebar .nav-link:hover {
            background-color: #f0f9ff;
            color: var(--primary-color);
            transform: translateX(4px);
        }

        .sidebar .nav-link.active {
            background-color: var(--primary-color);
            color: white;
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);
        }

        .sidebar .nav-link i {
            margin-right: 0.75rem;
            width: 18px;
            text-align: center;
        }

        .sidebar hr {
            border: 0;
            border-top: 1px solid var(--border-color);
            margin: 1.5rem 0;
        }

        .sidebar .nav-link.text-danger:hover {
            background-color: #fef2f2;
            color: var(--danger-color);
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            padding: 2rem;
            min-height: 100vh;
        }

        .card {
            border: none;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 2rem;
            background: white;
        }

        .card-header {
            background: white;
            border-bottom: 1px solid var(--border-color);
            padding: 1.5rem;
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .card-header h5 {
            color: var(--text-color);
            margin: 0;
            font-weight: 700;
        }

        .card-body {
            padding: 1.5rem;
        }

        .table th {
            background-color: var(--bg-color);
            color: var(--text-color);
            font-weight: 700;
            text-transform: uppercase;
            font-size: 0.75rem;
            letter-spacing: 0.5px;
            padding: 1.25rem;
            border-bottom: 2px solid var(--border-color);
        }

        .table td {
            padding: 1.25rem;
            border-bottom: 1px solid #f3f4f6;
            vertical-align: middle;
        }

        .table tbody tr:hover {
            background-color: #f9fafb;
        }

        .badge {
            padding: 0.5rem 0.875rem;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 700;
        }

        .badge.bg-primary {
            background-color: #dbeafe !important;
            color: #1e40af !important;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            font-size: 0.875rem;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        .btn-success {
            background-color: var(--success-color);
            color: white;
        }

        .btn-success:hover {
            background-color: var(--success-dark);
        }

        .btn-warning {
            background-color: var(--warning-color);
            color: white;
        }

        .btn-warning:hover {
            background-color: var(--warning-dark);
        }

        .btn-danger {
            background-color: var(--danger-color);
            color: white;
        }

        .btn-danger:hover {
            background-color: var(--danger-dark);
        }

        .btn-secondary {
            background-color: #6b7280;
            color: white;
        }

        .btn-secondary:hover {
            background-color: #4b5563;
        }

        .btn-sm {
            padding: 0.5rem 1rem;
            font-size: 0.75rem;
        }

        .alert {
            border-radius: 8px;
            border: none;
            padding: 1rem 1.5rem;
            margin-bottom: 1.5rem;
        }

        .alert-success {
            background-color: #f0fdf4;
            color: var(--success-color);
            border-left: 4px solid var(--success-color);
        }

        .form-control {
            border: 2px solid var(--border-color);
            border-radius: 8px;
            padding: 0.75rem;
            transition: border-color 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }

        .form-label {
            font-weight: 600;
            color: var(--text-color);
            margin-bottom: 0.5rem;
        }

        h1 {
            color: var(--text-color);
            margin-bottom: 2rem;
            font-size: 2rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }

            .main-content {
                margin-left: 0;
            }

            .btn-group {
                flex-direction: column;
                gap: 0.25rem;
            }

            .table-responsive {
                overflow-x: auto;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="logo">
            <h4><i class="fas fa-store"></i> KMG Store</h4>
            <small>Admin Panel</small>
        </div>

        <nav class="nav flex-column">
            <a class="nav-link" href="admin-dashboard.php">
                <i class="fas fa-tachometer-alt"></i> Dashboard
            </a>
            <a class="nav-link" href="transaksi.php">
                <i class="fas fa-shopping-cart"></i> Transaksi
            </a>
            <a class="nav-link active" href="pengguna.php">
                <i class="fas fa-users"></i> Pengguna
            </a>
            <a class="nav-link" href="productlist.php">
                <i class="fas fa-boxes"></i> Product List
            </a>
            <a class="nav-link" href="add_product.php">
                <i class="fas fa-plus-circle"></i> Tambah Produk
            </a>
            
            <hr>
            
            <a class="nav-link text-danger" href="logout.php">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <h1><i class="fas fa-users text-primary"></i> Kelola Pengguna</h1>
                    
                    <?php if (isset($message)): ?>
                        <div class="alert alert-success alert-dismissible fade show">
                            <i class="fas fa-check-circle"></i> <?php echo $message; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <!-- Form Tambah/Edit Pengguna -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="fas fa-<?php echo $edit_user ? 'edit' : 'plus'; ?>"></i>
                                <?php echo $edit_user ? 'Edit Pengguna' : 'Tambah Pengguna Baru'; ?>
                            </h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <input type="hidden" name="action" value="<?php echo $edit_user ? 'edit' : 'add'; ?>">
                                <?php if ($edit_user): ?>
                                    <input type="hidden" name="id" value="<?php echo $edit_user['id']; ?>">
                                <?php endif; ?>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="nama" class="form-label">Nama Lengkap</label>
                                        <input type="text" class="form-control" id="nama" name="nama" 
                                               value="<?php echo $edit_user['nama'] ?? ''; ?>" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="email" class="form-label">Email</label>
                                        <input type="email" class="form-control" id="email" name="email" 
                                               value="<?php echo $edit_user['email'] ?? ''; ?>" required>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="nohp" class="form-label">No. HP</label>
                                        <input type="text" class="form-control" id="nohp" name="nohp" 
                                               value="<?php echo $edit_user['nohp'] ?? ''; ?>" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="password" class="form-label">
                                            Password <?php echo $edit_user ? '(Kosongkan jika tidak ingin mengubah)' : ''; ?>
                                        </label>
                                        <input type="password" class="form-control" id="password" name="password" 
                                               <?php echo !$edit_user ? 'required' : ''; ?>>
                                    </div>
                                </div>
                                
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-success">
                                        <i class="fas fa-save"></i> <?php echo $edit_user ? 'Update' : 'Simpan'; ?>
                                    </button>
                                    <?php if ($edit_user): ?>
                                        <a href="pengguna.php" class="btn btn-secondary">
                                            <i class="fas fa-times"></i> Batal
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Tabel Pengguna -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="fas fa-list"></i> Daftar Pengguna</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Nama</th>
                                            <th>Email</th>
                                            <th>No. HP</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (count($users) > 0): ?>
                                            <?php foreach ($users as $user): ?>
                                                <tr>
                                                    <td><span class="badge bg-primary"><?php echo $user['id']; ?></span></td>
                                                    <td><?php echo htmlspecialchars($user['nama']); ?></td>
                                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                                    <td><?php echo htmlspecialchars($user['nohp']); ?></td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <a href="pengguna.php?edit=<?php echo $user['id']; ?>" 
                                                               class="btn btn-warning btn-sm">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                            <button type="button" class="btn btn-danger btn-sm" 
                                                                    onclick="deleteUser(<?php echo $user['id']; ?>, '<?php echo htmlspecialchars($user['nama']); ?>')">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="5" class="text-center">
                                                    <div class="py-4">
                                                        <i class="fas fa-user fa-3x text-muted mb-3"></i>
                                                        <p class="text-muted">Belum ada pengguna terdaftar</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Form untuk Delete (Hidden) -->
    <form id="deleteForm" method="POST" style="display: none;">
        <input type="hidden" name="action" value="delete">
        <input type="hidden" name="id" id="deleteId">
    </form>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script>
        function deleteUser(id, nama) {
            if (confirm(`Apakah Anda yakin ingin menghapus pengguna "${nama}"?`)) {
                document.getElementById('deleteId').value = id;
                document.getElementById('deleteForm').submit();
            }
        }

        // Auto hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    </script>
</body>
</html>