<?php
session_start();
include_once("config.php");
include_once("functions.php");

cek_login_user();

if (!isset($_SESSION['user_id'])) {
    header("Location: masuk.php");
    exit();
}

// Cek apakah ada data POST
if ($_SERVER["REQUEST_METHOD"] != "POST") {
    header("Location: index.php");
    exit();
}

// Debugging - menyimpan semua data POST untuk diperiksa
error_log("Data POST yang diterima: " . print_r($_POST, true));

// Tangkap data dari form
$userid = isset($_POST['userid']) ? htmlspecialchars($_POST['userid']) : '';
$zoneid = isset($_POST['zoneid']) ? htmlspecialchars($_POST['zoneid']) : '';
$nominal = isset($_POST['nominal']) ? $_POST['nominal'] : '';
$harga = isset($_POST['harga']) ? $_POST['harga'] : 0;
$metode = isset($_POST['metode']) ? htmlspecialchars($_POST['metode']) : '';
$whatsapp = isset($_POST['whatsapp']) ? htmlspecialchars($_POST['whatsapp']) : '';
$game_type = isset($_POST['game_type']) ? htmlspecialchars($_POST['game_type']) : 'ml';

// Debug untuk melihat nilai game_type yang diterima
// echo "Game type yang diterima: " . $game_type;

// Pastikan $harga adalah numerik
if (!is_numeric($harga)) {
    // Jika harga tidak numerik, coba ekstrak dari nominal
    if (preg_match('/Rp\s*([\d.,]+)/i', $nominal, $matches)) {
    $harga = (int) str_replace(['.', ','], '', $matches[1]);
    } else {
        $harga = 0;
    }
}

// Mapping nama game
$game_names = [
    'ml' => 'Mobile Legends',
    'pubg' => 'PUBG Mobile',
    'genshin' => 'Genshin Impact',
    'honor' => 'Honor of Kings',
    'valorant' => 'Valorant',
    'ff' => 'Free Fire'
];

// Ambil nama game berdasarkan tipe
$game_name = isset($game_names[$game_type]) ? $game_names[$game_type] : 'Mobile Legends';

// Pemetaan nama metode pembayaran yang lebih deskriptif
$metode_display = [
    'bca' => 'Bank BCA ',
    'bni' => 'Bank BNI ',
    'bri' => 'Bank BRI ',
    'mandiri' => 'Bank Mandiri ',
    'briva' => 'Bank BRIVA',
];

// Dapatkan nama metode pembayaran yang lebih deskriptif
$metode_nama = isset($metode_display[strtolower($metode)]) ? $metode_display[strtolower($metode)] : $metode;

// Generate kode transaksi unik
$kode_transaksi = "KMG" . time() . rand(100, 999);

// Generate nomor virtual account (contoh sederhana)
$va_number = "8277 " . sprintf("%04d", rand(1000, 9999)) . " " . sprintf("%04d", rand(1000, 9999)) . " " . sprintf("%04d", rand(1000, 9999));

// Simpan data transaksi ke session untuk digunakan nanti
$_SESSION['transaksi'] = [
    'kode' => $kode_transaksi,
    'userid' => $userid,
    'zoneid' => $zoneid,
    'nominal' => $nominal,
    'harga' => $harga,
    'metode' => $metode,
    'metode_nama' => $metode_nama,
    'va_number' => $va_number,
    'whatsapp' => $whatsapp,
    'tanggal' => date('Y-m-d H:i:s'),
    'game_type' => $game_type,
    'game_name' => $game_name
];

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Konfirmasi Pembayaran - KMGSTORE</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #1e1e1e;
      color: #fff;
    }
    .navbar {
      position: relative;
      background: #1e2635;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 10px 20px;
      z-index: 5;
      backdrop-filter: blur(10px);
    }
    .container {
      max-width: 800px;
      margin: auto;
      padding: 20px;
    }
    .payment-box {
      background: rgba(42, 42, 42, 0.8);
      backdrop-filter: blur(10px);
      padding: 20px;
      border-radius: 10px;
      margin-top: 20px;
    }
    .payment-details {
      background: rgba(0, 0, 0, 0.2);
      padding: 15px;
      border-radius: 5px;
      margin: 15px 0;
    }
    .detail-row {
      display: flex;
      justify-content: space-between;
      padding: 8px 0;
      border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }
    .submit-btn {
      background: goldenrod;
      border: none;
      padding: 15px;
      width: 100%;
      color: rgb(85, 32, 32);
      font-weight: bold;
      font-size: 16px;
      border-radius: 5px;
      cursor: pointer;
      margin-top: 20px;
    }
    .countdown {
      background: rgba(0, 0, 0, 0.3);
      padding: 10px;
      border-radius: 5px;
      text-align: center;
      font-size: 20px;
      font-weight: bold;
      margin: 20px 0;
    }
    .va-number {
      font-size: 24px;
      font-weight: bold;
      background: rgba(255, 255, 255, 0.1);
      padding: 10px;
      text-align: center;
      border-radius: 5px;
      margin: 15px 0;
    }
    .footer-bottom {
      background-color: #1e2635;
      color: white;
      padding: 20px;
      text-align: center;
      font-size: 13px;
      margin-top: 40px;
    }
  </style>
</head>
<body>

  <!-- Navbar -->
    <nav class="bg-gray-800 bg-opacity-80 backdrop-filter backdrop-blur-md sticky top-0 z-50 p-4 flex justify-between items-center shadow-lg">
        <!-- Kiri: Logo -->
        <div class="flex items-center space-x-3">
            <div class="relative">
                <!-- Perbaikan path gambar logo -->
                <img src="../img/logo-tokioiboy.jpg" alt="Logo Tokiboy Store" class="h-10 w-10 rounded-full border-2 border-yellow-500" />
                <div class="absolute -top-1 -right-1 h-3 w-3 bg-green-500 rounded-full"></div>
            </div>
            <div>
                <span class="text-xl font-bold bg-gradient-to-r from-yellow-400 via-yellow-300 to-yellow-500 text-transparent bg-clip-text">KMGSTORE</span>
                <p class="text-xs text-gray-400">Top Up Termurah & Tercepat</p>
            </div>
        </div>

        <!-- Kanan: Menu / User -->
        <div class="space-x-2 flex items-center">
            <?php if (isset($_SESSION['nama'])): ?>
                <div class="bg-gray-700 px-3 py-1 rounded-full flex items-center">
                    <i class="fas fa-user-circle mr-2"></i>
                    <span class="text-white">Halo, <?= htmlspecialchars($_SESSION['nama']) ?>!</span>
                </div>
                <a href="../index.php" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded-full flex items-center">
                    <i class="fas fa-home mr-1"></i> Home
                </a>
            <?php else: ?>
                <a href="masuk.php" class="bg-yellow-500 text-black px-3 py-1 rounded">Masuk</a>
                <a href="daftar.php" class="bg-gray-700 px-3 py-1 rounded border border-yellow-500">Daftar</a>
            <?php endif; ?>
        </div>
    </nav>

  <div class="container">
    <h1 class="text-2xl font-bold mb-4">Konfirmasi Pembayaran</h1>
    
    <!-- Debugging - Menampilkan nilai game_type -->
    <!-- <div class="bg-red-500 text-white p-2 mb-4">
      Game Type: <?= $game_type ?><br>
      Game Name: <?= $game_name ?>
    </div> -->
    <div class="payment-box">
      <div class="text-center mb-4">
        <h2 class="text-xl">Selesaikan Pembayaran Dalam</h2>
        <div class="countdown" id="countdown">23:59:59</div>
      </div>
      
      <div class="payment-details">
        <div class="detail-row">
          <div>ID Transaksi</div>
          <div><?= $kode_transaksi ?></div>
        </div>
        <div class="detail-row">
          <div>Tanggal</div>
          <div><?= date('d-m-Y H:i') ?></div>
        </div>
        <div class="detail-row">
          <div>Game</div>
          <div><?= $game_name ?></div>
        </div>
        <div class="detail-row">
          <div>User ID</div>
          <div><?= $userid ?><?= !empty($zoneid) ? " ($zoneid)" : "" ?></div>
        </div>
        <div class="detail-row">
          <div>Item</div>
          <div><?php
            $nominal_text = preg_replace('/Rp\s+[\d.,]+/', '', $nominal);
            echo trim($nominal_text);
          ?></div>
        </div>
        <div class="detail-row">
          <div>Metode Pembayaran</div>
          <div><?= !empty($metode_nama) ? $metode_nama : '' ?></div>
        </div>
        <div class="detail-row">
          <div>Total Pembayaran</div>
          <div>Rp <?= number_format(intval($harga), 0, ',', '.') ?></div>
        </div>
      </div>

      <?php if (strtolower($metode) === 'qris'): ?>
      <div class="text-center mt-4">
        <h3 class="font-bold mb-2">Scan QRIS untuk Pembayaran</h3>
        <img src="img/qris-example.png" alt="QRIS Code" class="mx-auto w-64 h-64 bg-white p-2 rounded">
        <p class="mt-2 text-sm">Scan kode QR di atas menggunakan aplikasi e-wallet atau m-banking Anda</p>
      </div>
      <?php else: ?>
      <div class="text-center mt-4">
        <h3 class="font-bold mb-2">Nomor Virtual Account</h3>
        <div class="va-number"><?= $va_number ?></div>
        <p class="text-sm">Transfer sesuai nominal yang tertera ke nomor Virtual Account di atas</p>
      </div>
      <?php endif; ?>

      <div class="mt-6">
        <h3 class="font-bold mb-2">Instruksi Pembayaran:</h3>
        <ol class="list-decimal ml-5 space-y-1 text-sm">
          <li>Silahkan lakukan pembayaran sesuai dengan total yang tertera</li>
          <li>Setelah melakukan pembayaran, klik tombol "Konfirmasi Pembayaran" di bawah</li>
          <li>Sistem akan memverifikasi pembayaran Anda</li>
          <?php if ($game_type === 'ml'): ?>
          <li>Setelah diverifikasi, diamond akan ditambahkan ke akun Anda</li>
          <?php elseif ($game_type === 'pubg'): ?>
          <li>Setelah diverifikasi, UC akan ditambahkan ke akun Anda</li>
          <?php elseif ($game_type === 'genshin'): ?>
          <li>Setelah diverifikasi, Genesis Crystal akan ditambahkan ke akun Anda</li>
          <?php elseif ($game_type === 'ff'): ?>
          <li>Setelah diverifikasi, Diamond akan ditambahkan ke akun Anda</li>
          <?php elseif ($game_type === 'valorant'): ?>
          <li>Setelah diverifikasi, Valorant Points akan ditambahkan ke akun Anda</li>
          <?php else: ?>
          <li>Setelah diverifikasi, item akan ditambahkan ke akun Anda</li>
          <?php endif; ?>
        </ol>
      </div>

      <form action="struk-pembayaran.php" method="POST">
        <input type="hidden" name="kode_transaksi" value="<?= $kode_transaksi ?>">
        <input type="hidden" name="game_type" value="<?= $game_type ?>">
        <button type="submit" class="submit-btn">Konfirmasi Pembayaran</button>
      </form>
    </div>
  </div>

  <div class="footer-bottom">© 2025 KMGSTORE. All Rights Reserved.</div>

  <script>
    // Countdown timer (24 jam)
    let hours = 23;
    let minutes = 59;
    let seconds = 59;
    
    function updateCountdown() {
      document.getElementById('countdown').innerHTML = 
        `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
      
      if (seconds > 0) {
        seconds--;
      } else {
        if (minutes > 0) {
          minutes--;
          seconds = 59;
        } else {
          if (hours > 0) {
            hours--;
            minutes = 59;
            seconds = 59;
          } else {
            // Waktu habis
            clearInterval(countdownInterval);
            alert("Waktu pembayaran habis!");
            window.location.href = "index.php";
          }
        }
      }
    }
    
    const countdownInterval = setInterval(updateCountdown, 1000);
  </script>

</body>
</html>