-- Membuat database
CREATE DATABASE IF NOT EXISTS `kmgstore` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `kmgstore`;

-- ========================================
-- Tabel: admin
-- ========================================
CREATE TABLE `admin` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Username` varchar(100) NOT NULL,
  `Password` varchar(255) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data contoh untuk tabel admin
INSERT INTO `admin` (`Id`, `Username`, `Password`) VALUES
(1, 'admin', 'admin123'),
(2, 'superadmin', 'super123');

-- ========================================
-- Tabel: produk (DIPERBAIKI)
-- ========================================
CREATE TABLE `produk` (
  `product_id` int(100) NOT NULL AUTO_INCREMENT,
  `product_nama_game` varchar(100) DEFAULT NULL,
  `product_item_jenis` varchar(100) DEFAULT NULL,
  `product_nominal` varchar(255) DEFAULT NULL,
  `product_total_bayar` int(100) DEFAULT NULL,
  PRIMARY KEY (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ========================================
-- Mobile Legends (game_type = 'ml')
-- ========================================
INSERT INTO `produk` (`product_nama_game`, `product_item_jenis`, `product_nominal`, `product_total_bayar`) VALUES
('Mobile Legends', 'Diamond', '86 Diamond', 22000),
('Mobile Legends', 'Diamond', '172 Diamond', 42000),
('Mobile Legends', 'Diamond', '257 Diamond', 65000),
('Mobile Legends', 'Diamond', '344 Diamond', 85000),
('Mobile Legends', 'Diamond', '429 Diamond', 105000),
('Mobile Legends', 'Diamond', '514 Diamond', 125000),
('Mobile Legends', 'Diamond', '706 Diamond', 165000),
('Mobile Legends', 'Diamond', '878 Diamond', 205000),
('Mobile Legends', 'Diamond', '1050 Diamond', 245000),
('Mobile Legends', 'Diamond', '1412 Diamond', 325000),
('Mobile Legends', 'Diamond', '2195 Diamond', 485000),
('Mobile Legends', 'Diamond', '3688 Diamond', 810000),
('Mobile Legends', 'Diamond', '5532 Diamond', 1215000),
('Mobile Legends', 'Diamond', '9288 Diamond', 2025000);
('Mobile Legends', 'Diamond', '1088 Diamond', 2025000);


-- ========================================
-- Valorant (game_type = 'valorant')
-- ========================================
INSERT INTO `produk` (`product_nama_game`, `product_item_jenis`, `product_nominal`, `product_total_bayar`) VALUES
('Valorant', 'VP', '300 VP', 30000),
('Valorant', 'VP', '625 VP', 65000),
('Valorant', 'VP', '1125 VP', 115000),
('Valorant', 'VP', '1950 VP', 195000),
('Valorant', 'VP', '3400 VP', 325000),
('Valorant', 'VP', '7000 VP', 650000);

-- ========================================
-- PUBG Mobile (game_type = 'pubg')
-- ========================================
INSERT INTO `produk` (`product_nama_game`, `product_item_jenis`, `product_nominal`, `product_total_bayar`) VALUES
('PUBG Mobile', 'UC', '60 UC', 15000),
('PUBG Mobile', 'UC', '325 UC', 75000),
('PUBG Mobile', 'UC', '660 UC', 150000),
('PUBG Mobile', 'UC', '1800 UC', 375000),
('PUBG Mobile', 'UC', '3850 UC', 750000),
('PUBG Mobile', 'UC', '8100 UC', 1500000);

-- ========================================
-- Genshin Impact (game_type = 'genshin')
-- ========================================
INSERT INTO `produk` (`product_nama_game`, `product_item_jenis`, `product_nominal`, `product_total_bayar`) VALUES
('Genshin Impact', 'Genesis Crystal', '60 Genesis Crystal', 15000),
('Genshin Impact', 'Genesis Crystal', '300 Genesis Crystal', 75000),
('Genshin Impact', 'Genesis Crystal', '980 Genesis Crystal', 235000),
('Genshin Impact', 'Genesis Crystal', '1980 Genesis Crystal', 475000),
('Genshin Impact', 'Genesis Crystal', '3280 Genesis Crystal', 790000),
('Genshin Impact', 'Genesis Crystal', '6480 Genesis Crystal', 1590000);

-- ========================================
-- Free Fire (game_type = 'ff')
-- ========================================
INSERT INTO `produk` (`product_nama_game`, `product_item_jenis`, `product_nominal`, `product_total_bayar`) VALUES
('Free Fire', 'Diamond', '50 Diamond', 8000),
('Free Fire', 'Diamond', '100 Diamond', 15000),
('Free Fire', 'Diamond', '310 Diamond', 48000),
('Free Fire', 'Diamond', '520 Diamond', 78000),
('Free Fire', 'Diamond', '1060 Diamond', 150000),
('Free Fire', 'Diamond', '2180 Diamond', 300000);

-- ========================================
-- Honor of Kings (game_type = 'honor')
-- ========================================
INSERT INTO `produk` (`product_nama_game`, `product_item_jenis`, `product_nominal`, `product_total_bayar`) VALUES
('Honor of Kings', 'Voucher', '60 Voucher', 15000),
('Honor of Kings', 'Voucher', '300 Voucher', 75000),
('Honor of Kings', 'Voucher', '600 Voucher', 150000),
('Honor of Kings', 'Voucher', '1200 Voucher', 300000),
('Honor of Kings', 'Voucher', '3000 Voucher', 750000),
('Honor of Kings', 'Voucher', '6000 Voucher', 1500000);

-- ========================================
-- Default/Other Games
-- ========================================
INSERT INTO `produk` (`product_nama_game`, `product_item_jenis`, `product_nominal`, `product_total_bayar`) VALUES
('Other Games', 'Paket', 'Paket Basic', 20000),
('Other Games', 'Paket', 'Paket Standard', 50000),
('Other Games', 'Paket', 'Paket Premium', 100000);

-- ========================================
-- Tabel: transaksi
-- ========================================
CREATE TABLE `transaksi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `tanggal` datetime DEFAULT NULL,
  `nama_game` varchar(200) DEFAULT NULL,
  `userid_game` varchar(50) DEFAULT NULL,
  `zoneid_game` varchar(20) DEFAULT NULL,
  `item_jenis` varchar(30) DEFAULT NULL,
  `nominal` varchar(100) DEFAULT NULL,
  `total_bayar` decimal(10,2) DEFAULT NULL,
  `metode_pembayaran` varchar(50) DEFAULT NULL,
  `whatsapp` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `kode_transaksi` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data contoh untuk tabel transaksi
INSERT INTO `transaksi` (`id`, `user_id`, `tanggal`, `nama_game`, `userid_game`, `zoneid_game`, `item_jenis`, `nominal`, `total_bayar`, `metode_pembayaran`, `whatsapp`, `status`, `kode_transaksi`) VALUES
(1, 1, '2024-01-15 10:30:00', 'Mobile Legends', '123456789', '1234', 'Diamond', '100 Diamond', 15000.00, 'Dana', '081234567890', 'Success', 'KS2024011510001'),
(2, 2, '2024-01-15 11:15:00', 'PUBG Mobile', '987654321', '5678', 'UC', '600 UC', 90000.00, 'Gopay', '081987654321', 'Pending', 'KS2024011511001'),
(3, 1, '2024-01-15 14:20:00', 'Free Fire', '456789123', '9876', 'Diamond', '500 Diamond', 75000.00, 'OVO', '081234567890', 'Success', 'KS2024011514001');

-- ========================================
-- Tabel: users
-- ========================================
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `nohp` varchar(20) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('admin','user') DEFAULT 'user',
  `last_login` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data contoh untuk tabel users
INSERT INTO `users` (`id`, `nama`, `email`, `nohp`, `password`, `role`, `last_login`, `created_at`, `updated_at`) VALUES
(1, 'John Doe', 'john@example.com', '081234567890', 'password123', 'user', '2024-01-15 10:00:00', '2024-01-10 08:00:00', '2024-01-15 10:00:00'),
(2, 'Jane Smith', 'jane@example.com', '081987654321', 'password456', 'user', '2024-01-15 11:00:00', '2024-01-12 09:00:00', '2024-01-15 11:00:00'),
(3, 'Admin User', 'admin@kingstore.com', '081555666777', 'admin123', 'admin', '2024-01-15 12:00:00', '2024-01-01 10:00:00', '2024-01-15 12:00:00');

-- ========================================
-- Menambahkan Foreign Key Constraints
-- ========================================
ALTER TABLE `transaksi` 
ADD CONSTRAINT `fk_transaksi_user` 
FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) 
ON DELETE SET NULL ON UPDATE CASCADE;

-- ========================================
-- Membuat Index untuk performa yang lebih baik
-- ========================================
CREATE INDEX `idx_transaksi_user_id` ON `transaksi` (`user_id`);
CREATE INDEX `idx_transaksi_tanggal` ON `transaksi` (`tanggal`);
CREATE INDEX `idx_transaksi_status` ON `transaksi` (`status`);
CREATE INDEX `idx_users_email` ON `users` (`email`);
CREATE INDEX `idx_users_role` ON `users` (`role`);