<?php
// File: get-topup-form.php
session_start();
include_once("config.php");
include_once("functions.php");

cek_login_user();

// Ambil tipe game dari URL parameter
$game_type = isset($_GET['game_type']) ? htmlspecialchars($_GET['game_type']) : 'ml';

// Kode untuk mendapatkan data game (sama seperti di topup-form.php)
$game_names = [
    'ml' => 'Mobile Legends',
    'pubg' => 'PUBG Mobile',
    'genshin' => 'Genshin Impact',
    'honor' => 'Honor of Kings',
    'valorant' => 'Valorant',
    'ff' => 'Free Fire'
];

$game_name = isset($game_names[$game_type]) ? $game_names[$game_type] : 'Mobile Legends';

$game_currency = [
    'ml' => 'Diamond',
    'pubg' => 'UC',
    'genshin' => 'Genesis Crystal',
    'honor' => 'Voucher',
    'valorant' => 'Valorant Points',
    'ff' => 'Diamond'
];

$currency = isset($game_currency[$game_type]) ? $game_currency[$game_type] : 'Item';

$nominal_options = [];
?>
<!-- Header modal -->
<div class="modal-header p-4 border-b border-gray-700 flex justify-between items-center">
  <h2 class="text-xl font-bold">Top Up <?= $game_name ?></h2>
  <button onclick="closeTopUpModal()" class="text-white text-2xl">&times;</button>
</div>

<!-- Form content -->
<div class="p-4">
  <form action="konfirmasi-pembayaran.php" method="POST">
    <!-- Copy form content dari topup-form.php ke sini -->
    <!-- Hidden field untuk menyimpan tipe game -->
    <input type="hidden" name="game_type" value="<?= $game_type ?>">
    
    <div class="form-group">
      <label class="form-label">User ID <?= $game_name ?></label>
      <input type="text" name="userid" class="form-input" placeholder="Masukkan User ID" required>
      <?php if ($game_type === 'ml'): ?>
      <div class="mt-2">
        <label class="form-label">Zone ID</label>
        <input type="text" name="zoneid" class="form-input" placeholder="Masukkan Zone ID">
        <p class="text-xs text-gray-400 mt-1">Contoh: 12345678 (1234)</p>
      </div>
      <?php endif; ?>
    </div>
    
    <div class="form-group">
      <label class="form-label">Pilih Nominal <?= $currency ?></label>
      <div class="nominal-options">
        <?php foreach ($nominal_options as $index => $option): ?>
          <div class="nominal-option" data-value="<?= $option['label'] ?> - Rp <?= number_format($option['price'], 0, ',', '.') ?>" data-price="<?= $option['price'] ?>">
            <div class="font-bold"><?= $option['label'] ?></div>
            <div class="text-yellow-400">Rp <?= number_format($option['price'], 0, ',', '.') ?></div>
          </div>
        <?php endforeach; ?>
      </div>
      <input type="hidden" name="nominal" id="selected-nominal" required>
      <input type="hidden" name="harga" id="selected-price" required>
    </div>
    
    <div class="form-group">
      <label class="form-label">Metode Pembayaran</label>
      <div class="payment-methods">
        <!-- Copy payment methods dari topup-form.php ke sini -->
      </div>
      <input type="hidden" name="metode" id="selected-payment" required>
    </div>
    
    <div class="form-group">
      <label class="form-label">Nomor WhatsApp</label>
      <input type="text" name="whatsapp" class="form-input" placeholder="Masukkan Nomor WhatsApp" required>
      <p class="text-xs text-gray-400 mt-1">Untuk notifikasi pembelian & transaksi</p>
    </div>
    
    <button type="submit" class="submit-btn">Beli Sekarang</button>
  </form>
</div>

<script>
// Copy script untuk pilihan nominal dan metode pembayaran dari topup-form.php
// Script untuk pilihan nominal
document.querySelectorAll('.nominal-option').forEach(option => {
  option.addEventListener('click', function() {
    // Reset semua pilihan
    document.querySelectorAll('.nominal-option').forEach(el => {
      el.classList.remove('selected');
    });
    
    // Pilih yang diklik
    this.classList.add('selected');
    
    // Update hidden input
    document.getElementById('selected-nominal').value = this.dataset.value;
    document.getElementById('selected-price').value = this.dataset.price;
  });
});

// Script untuk metode pembayaran
document.querySelectorAll('.payment-method').forEach(method => {
  method.addEventListener('click', function() {
    // Reset semua pilihan
    document.querySelectorAll('.payment-method').forEach(el => {
      el.classList.remove('selected');
    });
    
    // Pilih yang diklik
    this.classList.add('selected');
    
    // Update hidden input
    document.getElementById('selected-payment').value = this.dataset.value;
  });
});
</script>