<?php

if (session_status() == PHP_SESSION_NONE) {
    session_start(); 
}


function cek_login_user() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: masuk.php");
        exit();
    }
}

function format_rupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}


function cek_login_admin() {
    if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
        header("Location: login.php");
        exit();
    }
}


function cek_login_umum() {
    if (isset($_SESSION['user_id'])) {
        
        if ($_SESSION['role'] === 'admin') {
            header("Location: admin-dashboard.php"); 
        } else {
            header("Location: dashboard.php"); 
        }
        exit();
    }
}


function clean_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

/**
 * Generate a random string for transaction IDs
 */
function generate_random_string($length = 8) {
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';
    
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    
    return $randomString;
}

/**
 * Format price with Indonesian format (e.g. 10.000)
 */
function format_price($price) {
    return number_format($price, 0, ',', '.');
}

/**
 * Log errors to a file
 */
function log_error($message) {
    $log_file = __DIR__ . '/error_log.txt';
    $date = date('Y-m-d H:i:s');
    $log_message = "[$date] $message\n";
    file_put_contents($log_file, $log_message, FILE_APPEND);
}





?>
