<?php
// Konfigurasi database
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'kmgstore';

// Membuat koneksi ke database
$conn = new mysqli($host, $username, $password, $database);

// Cek koneksi
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Set charset untuk menghindari masalah encoding
$conn->set_charset("utf8");

// Inisialisasi variabel
$error_message = "";
$success_message = "";
$product_data = null;

// Cek apakah ada ID produk yang dikirim
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: productlist.php");
    exit();
}

$product_id = (int)$_GET['id'];

// Ambil data produk berdasarkan ID
$sql_select = "SELECT * FROM produk WHERE product_id = ?";
$stmt_select = $conn->prepare($sql_select);
$stmt_select->bind_param("i", $product_id);
$stmt_select->execute();
$result = $stmt_select->get_result();

if ($result->num_rows == 0) {
    header("Location: productlist.php");
    exit();
}

$product_data = $result->fetch_assoc();

// Proses form ketika disubmit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Ambil data dari form
    $nama_game = trim($_POST['nama_game']);
    $item_jenis = trim($_POST['item_jenis']);
    $nominal = trim($_POST['nominal']);
    $total_bayar = (float)str_replace(['Rp', '.', ',', ' '], '', $_POST['total_bayar']);
    
    // Validasi input
    if (empty($nama_game)) {
        $error_message = "Nama game tidak boleh kosong!";
    } elseif (empty($item_jenis)) {
        $error_message = "Jenis item tidak boleh kosong!";
    } elseif (empty($nominal)) {
        $error_message = "Nominal tidak boleh kosong!";
    } elseif ($total_bayar <= 0) {
        $error_message = "Total bayar harus lebih dari 0!";
    } else {
        // Update data ke database
        $sql_update = "UPDATE produk SET 
                      product_nama_game = ?, 
                      product_item_jenis = ?, 
                      product_nominal = ?, 
                      product_total_bayar = ? 
                      WHERE product_id = ?";
        
        $stmt_update = $conn->prepare($sql_update);
        $stmt_update->bind_param("sssdi", $nama_game, $item_jenis, $nominal, $total_bayar, $product_id);
        
        if ($stmt_update->execute()) {
            $success_message = "Produk berhasil diperbarui!";
            // Refresh data produk
            $stmt_select->execute();
            $result = $stmt_select->get_result();
            $product_data = $result->fetch_assoc();
        } else {
            $error_message = "Gagal memperbarui produk: " . $conn->error;
        }
        
        $stmt_update->close();
    }
}

$stmt_select->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Produk - KMGSTORE</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #333;
            text-align: center;
            margin-bottom: 30px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #333;
        }
        input[type="text"],
        input[type="number"],
        select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box;
        }
        input[type="text"]:focus,
        input[type="number"]:focus,
        select:focus {
            outline: none;
            border-color: #4CAF50;
        }
        .btn {
            padding: 12px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            font-size: 14px;
            display: inline-block;
            text-align: center;
            margin-right: 10px;
        }
        .btn-primary {
            background-color: #4CAF50;
            color: white;
        }
        .btn-primary:hover {
            background-color: #45a049;
        }
        .btn-secondary {
            background-color: #6c757d;
            color: white;
        }
        .btn-secondary:hover {
            background-color: #5a6268;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        .alert-success {
            color: #155724;
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
        }
        .alert-error {
            color: #721c24;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
        }
        .form-actions {
            text-align: center;
            margin-top: 30px;
        }
        .currency-input {
            position: relative;
        }
        .currency-prefix {
            position: absolute;
            left: 10px;
            top: 50%;
            transform: translateY(-50%);
            color: #666;
            pointer-events: none;
        }
        .currency-input input {
            padding-left: 30px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Edit Produk</h1>
        
        <!-- Pesan sukses atau error -->
        <?php if (!empty($success_message)): ?>
            <div class="alert alert-success">
                <?php echo $success_message; ?>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($error_message)): ?>
            <div class="alert alert-error">
                <?php echo $error_message; ?>
            </div>
        <?php endif; ?>
        
        <!-- Form edit produk -->
        <form method="POST" action="">
            <div class="form-group">
                <label for="nama_game">Nama Game:</label>
                <input type="text" 
                       id="nama_game" 
                       name="nama_game" 
                       value="<?php echo htmlspecialchars($product_data['product_nama_game']); ?>" 
                       required>
            </div>
            
            <div class="form-group">
                <label for="item_jenis">Jenis Item:</label>
                <input type="text" 
                       id="item_jenis" 
                       name="item_jenis" 
                       value="<?php echo htmlspecialchars($product_data['product_item_jenis']); ?>" 
                       required>
            </div>
            
            <div class="form-group">
                <label for="nominal">Nominal:</label>
                <input type="text" 
                       id="nominal" 
                       name="nominal" 
                       value="<?php echo htmlspecialchars($product_data['product_nominal']); ?>" 
                       required>
            </div>
            
            <div class="form-group">
                <label for="total_bayar">Total Bayar:</label>
                <div class="currency-input">
                    <span class="currency-prefix">Rp</span>
                    <input type="text" 
                           id="total_bayar" 
                           name="total_bayar" 
                           value="<?php echo number_format($product_data['product_total_bayar'], 0, ',', '.'); ?>" 
                           required>
                </div>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Perbarui Produk</button>
                <a href="productlist.php" class="btn btn-secondary">Kembali</a>
            </div>
        </form>
    </div>

    <script>
        // Format input currency
        document.getElementById('total_bayar').addEventListener('input', function(e) {
            let value = e.target.value.replace(/[^\d]/g, '');
            if (value) {
                value = parseInt(value).toLocaleString('id-ID');
            }
            e.target.value = value;
        });
        
        // Format currency pada saat load
        document.addEventListener('DOMContentLoaded', function() {
            let totalBayarInput = document.getElementById('total_bayar');
            let value = totalBayarInput.value.replace(/[^\d]/g, '');
            if (value) {
                value = parseInt(value).toLocaleString('id-ID');
                totalBayarInput.value = value;
            }
        });
    </script>
</body>
</html>

<?php
// Tutup koneksi database
$conn->close();
?>